<?php
namespace model;

class Rating extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'user_id'		=>	'INT UNSIGNED',
				'target'		=>	'ENUM("game", "user")',
				'target_id'		=>	'INT UNSIGNED',
				
				'stars'			=>	'TINYINT'
			))
		);
	}
	
	// Validation
	public function columns()
	{
		return array
		(
			'user_id'	=>	array('text', array()),
			'target'	=>	array('select', array('game', 'user')),
			'target_id'	=>	array('text', array()),
			
			'stars'		=>	array('text', array('positive_integer'=>true, 'less_than'=>11))
		);
	}
}